﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;

namespace _24Cxx
{
    public partial class Form1 : Form
    {
        [DllImport("umf.DLL", EntryPoint = "fw_init")]
        public static extern Int32 fw_init(Int16 port, Int32 baud);
        [DllImport("umf.DLL", EntryPoint = "fw_exit")]
        public static extern Int32 fw_exit(Int32 icdev);

        [DllImport("umf.DLL", EntryPoint = "fw_rdCardStatus")]
        public static extern Int32 fw_rdCardStatus(Int32 icdev, Int32 [] pSt);

        [DllImport("umf.DLL", EntryPoint = "fw_read_24cxx")]
        public static extern Int32 fw_read_24cxx(Int32 icdev, Int32 address, Int32 rlen, byte[] pDataR);
        [DllImport("umf.DLL", EntryPoint = "fw_write_24cxx")]
        public static extern Int32 fw_write_24cxx(Int32 icdev, Int32 address, Int32 wlen, byte[] pDataW);


        Int32 gl_icdev = -1;

        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            tb_address.Text = "0";
            tb_data.Text = "This is a test";
            tb_length.Text = tb_data .Text.ToString ().Length .ToString ();
        }

        private bool checkReadOpenState()
        {
            if (-1 == gl_icdev)
            {
                MessageBox.Show("Reader is not opened");
                return false;
            }
            else
                return true;
        }

        private bool checkCardInsertState()
        {
            Int32[] cardSt = new Int32[2];
            Int32  opst;

            opst = fw_rdCardStatus(gl_icdev, cardSt);
            if (opst != 0)
            {
                MessageBox.Show("Check card state error");
                return false ;
            }

            if (0 == cardSt[0])
            {
                MessageBox.Show("Found no card insert");
                return false ;
            }

            return true;

        }

        private void btn_open_Click(object sender, EventArgs e)
        {
            gl_icdev = fw_init(100, 115200);//100->USB port, other value serial port

            if (-1 == gl_icdev)
            {
                MessageBox.Show("Open reader failed");
                return;
            }

            MessageBox.Show("Open reader ok");

        }

        private void btn_read_Click(object sender, EventArgs e)
        {
            int address, length;
            byte[] bufData = new byte[1024];
            int opst;

            if (false == checkReadOpenState())
                return;

            if(false == checkCardInsertState())
                return;

            address = int.Parse (tb_address.Text.ToString ());
            length = int.Parse(tb_length.Text.ToString());


            opst = fw_read_24cxx(gl_icdev, address, length, bufData);
            if (opst != 0)
            {
                MessageBox.Show("read error");
                return;
            }

            tb_data.Text = System.Text.Encoding.Default.GetString(bufData);

            MessageBox.Show("Read ok");


        }

        private void btn_write_Click(object sender, EventArgs e)
        {
            int address, length;
            byte[] bufData = new byte[1024];
            int opst;

            if (false == checkReadOpenState())
                return;

            if (false == checkCardInsertState())
                return;

            address = int.Parse(tb_address.Text.ToString());
            length = int.Parse(tb_length.Text.ToString());

            bufData = System.Text.Encoding.Default.GetBytes(tb_data.Text.ToString());

            opst = fw_write_24cxx(gl_icdev, address, length, bufData);
            if (opst != 0)
            {
                MessageBox.Show("Write error");
                return;
            }

            MessageBox.Show("Write ok");
            
        }

        private void tb_data_TextChanged(object sender, EventArgs e)
        {
            tb_length.Text = tb_data.Text.ToString().Length.ToString();
        }
    }
}
